# Copyright (c) 2025 Löwenfelsen UG (haftungsbeschränkt)
# Copyright (c) 2025 Philipp Schafft

# licensed under Artistic License 2.0 (see LICENSE file)

# ABSTRACT: Work with display colours (internal data)

# ---- WARNING WARNING WARNING ----#
#  THIS PACKAGE IS AUTOGENERATED!  #
#  Do not manually edit this file! #
# ---- WARNING WARNING WARNING ----#

package Data::Displaycolour::Data;

use v5.20;
use strict;
use warnings;

use Carp;

our $VERSION = v0.01;

my %_extra_data = (
    red      => [qw(fire feuer america amerika fox vixen fuchs), "f\N{U+00FC}chsin"],
    green    => [qw(australia australien)],
    blue     => [qw(water wasser sky himmel ice europe europa male man men mann herr), "m\N{U+00E4}nnlich", "m\N{U+00E4}nnchen"],
    yellow   => [qw(lemon zitrone asia asien)],
    magenta  => [qw(female woman women frau dame weiblich weib weibschen)],
    grey     => [qw(gray mouse mice maus rat ratte ratten), "m\N{U+00E4}use"],
    black    => [qw(africa afrika)],
    savannah => [qw(savannah savanne lion leo), "l\N{U+00F6}we", "l\N{U+00F6}win"],
);
our %_extra;

foreach my $key (keys %_extra_data) {
    $_extra{$_} = $key foreach @{$_extra_data{$key}};
}
our @_extra_keys = sort {length($b) <=> length($a) || $b cmp $a} keys %_extra;
our %_names = (
    en => {
        'black' => 'black',
        'blue' => 'blue',
        'brown' => 'brown',
        'cyan' => 'cyan',
        'green' => 'green',
        'grey' => 'grey',
        'magenta' => 'magenta',
        'orange' => 'orange',
        'red' => 'red',
        'white' => 'white',
        'yellow' => 'yellow',
        __order__ => ['magenta','yellow','orange','white','green','brown','black','grey','cyan','blue','red'],
    },
    de => {
        'schwartz' => 'black',
        'blau' => 'blue',
        'braun' => 'brown',
        'cyan' => 'cyan',
        "gr\N{U+00FC}n" => 'green',
        'grau' => 'grey',
        'magenta' => 'magenta',
        'orange' => 'orange',
        'rot' => 'red',
        "wei\N{U+00DF}" => 'white',
        'weiss' => 'white',
        'gelb' => 'yellow',
        __order__ => ['schwartz','magenta','orange','weiss','braun',"wei\N{U+00DF}","gr\N{U+00FC}n",'grau','gelb','cyan','blau','rot'],
    },
    nl => {
        'zwart' => 'black',
        'blauw' => 'blue',
        'bruin' => 'brown',
        'cyaan' => 'cyan',
        'groen' => 'green',
        'grauw' => 'grey',
        'magenta' => 'magenta',
        'oranje' => 'orange',
        'rood' => 'red',
        'wit' => 'white',
        'geel' => 'yellow',
        __order__ => ['magenta','oranje','zwart','groen','grauw','cyaan','bruin','blauw','rood','geel','wit'],
    },
    ca => {
        'negre' => 'black',
        'blau' => 'blue',
        "marr\N{U+00F3}" => 'brown',
        'cian' => 'cyan',
        'verd' => 'green',
        'gris' => 'grey',
        'magenta' => 'magenta',
        'taronja' => 'orange',
        'vermell' => 'red',
        'blanc' => 'white',
        'groc' => 'yellow',
        __order__ => ['vermell','taronja','magenta','negre',"marr\N{U+00F3}",'blanc','verd','groc','gris','cian','blau'],
    },
    da => {
        'sort' => 'black',
        "bl\N{U+00E5}" => 'blue',
        'brun' => 'brown',
        "gr\N{U+00F8}n" => 'green',
        "gr\N{U+00E5}" => 'grey',
        'orange' => 'orange',
        'appelsinfarvet' => 'orange',
        'orangefarvet' => 'orange',
        "r\N{U+00F8}d" => 'red',
        'hvid' => 'white',
        'gul' => 'yellow',
        __order__ => ['appelsinfarvet','orangefarvet','orange','sort','hvid',"gr\N{U+00F8}n",'brun',"r\N{U+00F8}d",'gul',"gr\N{U+00E5}","bl\N{U+00E5}"],
    },
    eo => {
        'nigra' => 'black',
        'blua' => 'blue',
        'bruna' => 'brown',
        'ciankoloro' => 'cyan',
        'verda' => 'green',
        'griza' => 'grey',
        "oran\N{U+011D}a" => 'orange',
        "ru\N{U+011D}a" => 'red',
        'blanka' => 'white',
        'flava' => 'yellow',
        __order__ => ['ciankoloro',"oran\N{U+011D}a",'blanka','verda','nigra','griza','flava','bruna',"ru\N{U+011D}a",'blua'],
    },
    es => {
        'negro' => 'black',
        'azul' => 'blue',
        'celeste' => 'blue',
        'blao' => 'blue',
        "marr\N{U+00F3}n" => 'brown',
        "casta\N{U+00F1}o" => 'brown',
        'pardo' => 'brown',
        "caf\N{U+00E9}" => 'brown',
        'canelo' => 'brown',
        'carmelita' => 'brown',
        'carmelito' => 'brown',
        'moreno' => 'brown',
        'bronceado' => 'brown',
        'cian' => 'cyan',
        'verde' => 'green',
        'gris' => 'grey',
        'cenicento' => 'grey',
        'magenta' => 'magenta',
        'naranja' => 'orange',
        'butano' => 'orange',
        'rojo' => 'red',
        'colorado' => 'red',
        'rubicundo' => 'red',
        'rubro' => 'red',
        'rufo' => 'red',
        "r\N{U+00FA}beo" => 'red',
        'blanco' => 'white',
        'albo' => 'white',
        'amarillo' => 'yellow',
        __order__ => ['rubicundo','cenicento','carmelito','carmelita','bronceado','colorado','amarillo','naranja','magenta','celeste',"casta\N{U+00F1}o",'moreno',"marr\N{U+00F3}n",'canelo','butano','blanco','verde',"r\N{U+00FA}beo",'rubro','pardo','negro','rufo','rojo','gris','cian',"caf\N{U+00E9}",'blao','azul','albo'],
    },
    eu => {
        'beltz' => 'black',
        'urdin' => 'blue',
        'marroi' => 'brown',
        'berde' => 'green',
        'orlegi' => 'green',
        'gris' => 'grey',
        'laranja' => 'orange',
        'gorri' => 'red',
        'zuri' => 'white',
        'hori' => 'yellow',
        __order__ => ['laranja','orlegi','marroi','urdin','gorri','berde','beltz','zuri','hori','gris'],
    },
    fi => {
        'musta' => 'black',
        'sininen' => 'blue',
        'ruskea' => 'brown',
        'turkoosi' => 'cyan',
        "vihre\N{U+00E4}" => 'green',
        'harmaa' => 'grey',
        'magenta' => 'magenta',
        'oranssi' => 'orange',
        'punainen' => 'red',
        'valkoinen' => 'white',
        'keltainen' => 'yellow',
        __order__ => ['valkoinen','keltainen','turkoosi','punainen','sininen','oranssi','magenta',"vihre\N{U+00E4}",'ruskea','harmaa','musta'],
    },
    fo => {
        'svartur' => 'black',
        "bl\N{U+00E1}ur" => 'blue',
        "br\N{U+00FA}nur" => 'brown',
        "bl\N{U+00E1}gr\N{U+00F8}nur" => 'cyan',
        "gr\N{U+00F8}nur" => 'green',
        "gr\N{U+00E1}r" => 'grey',
        'appilsingulur' => 'orange',
        'brandgulur' => 'orange',
        "rey\N{U+00F0}ur" => 'red',
        "hv\N{U+00ED}tur" => 'white',
        'gulur' => 'yellow',
        __order__ => ['appilsingulur','brandgulur',"bl\N{U+00E1}gr\N{U+00F8}nur",'svartur',"rey\N{U+00F0}ur","hv\N{U+00ED}tur","gr\N{U+00F8}nur","br\N{U+00FA}nur",'gulur',"bl\N{U+00E1}ur","gr\N{U+00E1}r"],
    },
    fr => {
        'noir' => 'black',
        'bleu' => 'blue',
        'azur' => 'blue',
        'marron' => 'brown',
        'brun' => 'brown',
        'cyan' => 'cyan',
        'vert' => 'green',
        'gris' => 'grey',
        'magenta' => 'magenta',
        'orange' => 'orange',
        'rouge' => 'red',
        'blanc' => 'white',
        'blanche' => 'white',
        'jaune' => 'yellow',
        __order__ => ['magenta','blanche','orange','marron','rouge','jaune','blanc','vert','noir','gris','cyan','brun','bleu','azur'],
    },
    ga => {
        'dubh' => 'black',
        'gorm' => 'blue',
        'donn' => 'brown',
        'ciano' => 'cyan',
        'glas' => 'green',
        'uaine' => 'green',
        'liath' => 'grey',
        'maigeanta' => 'magenta',
        "or\N{U+00E1}iste" => 'orange',
        "flannbhu\N{U+00ED}" => 'orange',
        'dearg' => 'red',
        'rua' => 'red',
        "b\N{U+00E1}n" => 'white',
        "bu\N{U+00ED}" => 'yellow',
        __order__ => ['maigeanta',"flannbhu\N{U+00ED}","or\N{U+00E1}iste",'uaine','liath','dearg','ciano','gorm','glas','dubh','donn','rua',"b\N{U+00E1}n","bu\N{U+00ED}"],
    },
    gl => {
        'negro' => 'black',
        'preto' => 'black',
        'azul' => 'blue',
        "marr\N{U+00F3}n" => 'brown',
        "casta\N{U+00F1}o" => 'brown',
        'pardo' => 'brown',
        'brun' => 'brown',
        'cian' => 'cyan',
        'verde' => 'green',
        'cincento' => 'grey',
        'gris' => 'grey',
        'borrallento' => 'grey',
        'maxenta' => 'magenta',
        'laranxa' => 'orange',
        'vermello' => 'red',
        'rubio' => 'red',
        'branco' => 'white',
        'amarelo' => 'yellow',
        __order__ => ['borrallento','vermello','cincento','maxenta','laranxa',"casta\N{U+00F1}o",'amarelo',"marr\N{U+00F3}n",'branco','verde','rubio','preto','pardo','negro','gris','cian','brun','azul'],
    },
    gr => {
        "\N{U+03BC}\N{U+03B1}\N{U+03CD}\N{U+03C1}\N{U+03BF}\N{U+03C2}" => 'black',
        "\N{U+03BC}\N{U+03C0}\N{U+03BB}\N{U+03B5}" => 'blue',
        "\N{U+03BA}\N{U+03B1}\N{U+03C6}\N{U+03AD}" => 'brown',
        "\N{U+03BA}\N{U+03B1}\N{U+03C3}\N{U+03C4}\N{U+03B1}\N{U+03BD}\N{U+03CC}" => 'brown',
        "\N{U+03B3}\N{U+03B1}\N{U+03BB}\N{U+03AC}\N{U+03B6}\N{U+03B9}\N{U+03BF}\N{U+03C2}" => 'cyan',
        "\N{U+03C0}\N{U+03C1}\N{U+03AC}\N{U+03C3}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}" => 'green',
        "\N{U+03B3}\N{U+03BA}\N{U+03C1}\N{U+03AF}\N{U+03B6}\N{U+03BF}\N{U+03C2}" => 'grey',
        "\N{U+03C6}\N{U+03B1}\N{U+03B9}\N{U+03CC}\N{U+03C2}" => 'grey',
        "\N{U+03BC}\N{U+03B1}\N{U+03C4}\N{U+03B6}\N{U+03AD}\N{U+03BD}\N{U+03C4}\N{U+03B1}" => 'magenta',
        "\N{U+03C0}\N{U+03BF}\N{U+03C1}\N{U+03C4}\N{U+03BF}\N{U+03BA}\N{U+03B1}\N{U+03BB}\N{U+03AE}\N{U+03C2}" => 'orange',
        "\N{U+03BA}\N{U+03CC}\N{U+03BA}\N{U+03BA}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}" => 'red',
        "\N{U+03AC}\N{U+03C3}\N{U+03C0}\N{U+03C1}\N{U+03BF}\N{U+03C2}" => 'white',
        "\N{U+03BB}\N{U+03B5}\N{U+03C5}\N{U+03BA}\N{U+03CC}\N{U+03C2}" => 'white',
        "\N{U+03BA}\N{U+03AF}\N{U+03C4}\N{U+03C1}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}" => 'yellow',
        __order__ => ["\N{U+03C0}\N{U+03BF}\N{U+03C1}\N{U+03C4}\N{U+03BF}\N{U+03BA}\N{U+03B1}\N{U+03BB}\N{U+03AE}\N{U+03C2}","\N{U+03C0}\N{U+03C1}\N{U+03AC}\N{U+03C3}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}","\N{U+03BC}\N{U+03B1}\N{U+03C4}\N{U+03B6}\N{U+03AD}\N{U+03BD}\N{U+03C4}\N{U+03B1}","\N{U+03BA}\N{U+03CC}\N{U+03BA}\N{U+03BA}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}","\N{U+03BA}\N{U+03AF}\N{U+03C4}\N{U+03C1}\N{U+03B9}\N{U+03BD}\N{U+03BF}\N{U+03C2}","\N{U+03B3}\N{U+03B1}\N{U+03BB}\N{U+03AC}\N{U+03B6}\N{U+03B9}\N{U+03BF}\N{U+03C2}","\N{U+03BA}\N{U+03B1}\N{U+03C3}\N{U+03C4}\N{U+03B1}\N{U+03BD}\N{U+03CC}","\N{U+03B3}\N{U+03BA}\N{U+03C1}\N{U+03AF}\N{U+03B6}\N{U+03BF}\N{U+03C2}","\N{U+03BC}\N{U+03B1}\N{U+03CD}\N{U+03C1}\N{U+03BF}\N{U+03C2}","\N{U+03BB}\N{U+03B5}\N{U+03C5}\N{U+03BA}\N{U+03CC}\N{U+03C2}","\N{U+03AC}\N{U+03C3}\N{U+03C0}\N{U+03C1}\N{U+03BF}\N{U+03C2}","\N{U+03C6}\N{U+03B1}\N{U+03B9}\N{U+03CC}\N{U+03C2}","\N{U+03BC}\N{U+03C0}\N{U+03BB}\N{U+03B5}","\N{U+03BA}\N{U+03B1}\N{U+03C6}\N{U+03AD}"],
    },
    is => {
        'svartur' => 'black',
        "bl\N{U+00E1}r" => 'blue',
        "br\N{U+00FA}nn" => 'brown',
        "gr\N{U+00E6}nn" => 'green',
        "gr\N{U+00E1}r" => 'grey',
        "appels\N{U+00ED}nugulur" => 'orange',
        "rau\N{U+00F0}ur" => 'red',
        "hv\N{U+00ED}tur" => 'white',
        'gulur' => 'yellow',
        __order__ => ["appels\N{U+00ED}nugulur",'svartur',"rau\N{U+00F0}ur","hv\N{U+00ED}tur",'gulur',"gr\N{U+00E6}nn","br\N{U+00FA}nn","gr\N{U+00E1}r","bl\N{U+00E1}r"],
    },
    it => {
        'nero' => 'black',
        'azzurro' => 'blue',
        'celeste' => 'blue',
        'blu' => 'blue',
        'marrone' => 'brown',
        'castano' => 'brown',
        'bruno' => 'brown',
        'ciano' => 'cyan',
        'verde' => 'green',
        'grigio' => 'grey',
        'magenta' => 'magenta',
        'arancione' => 'orange',
        'aranciato' => 'orange',
        'rosso' => 'red',
        'rubino' => 'red',
        'bianco' => 'white',
        'giallo' => 'yellow',
        __order__ => ['arancione','aranciato','marrone','magenta','celeste','castano','azzurro','rubino','grigio','giallo','bianco','verde','rosso','ciano','bruno','nero','blu'],
    },
    ja => {
        "\N{U+9ED2}\N{U+3044}" => 'black',
        "\N{U+9752}\N{U+3044}" => 'blue',
        "\N{U+8336}\N{U+8272}" => 'brown',
        "\N{U+8910}\N{U+8272}" => 'brown',
        "\N{U+9752}\N{U+7DD1}\N{U+8272}" => 'cyan',
        "\N{U+7DD1}" => 'green',
        "\N{U+7070}\N{U+8272}" => 'grey',
        "\N{U+9F20}\N{U+8272}" => 'grey',
        "\N{U+30DE}\N{U+30BC}\N{U+30F3}\N{U+30BF}" => 'magenta',
        "\N{U+30AA}\N{U+30EC}\N{U+30F3}\N{U+30B8}\N{U+8272}" => 'orange',
        "\N{U+6A59}\N{U+8272}" => 'orange',
        "\N{U+72D0}\N{U+8272}" => 'orange',
        "\N{U+871C}\N{U+67D1}\N{U+8272}" => 'orange',
        "\N{U+8D64}\N{U+3044}" => 'red',
        "\N{U+767D}\N{U+3044}" => 'white',
        "\N{U+9EC4}\N{U+8272}" => 'yellow',
        __order__ => ["\N{U+30AA}\N{U+30EC}\N{U+30F3}\N{U+30B8}\N{U+8272}","\N{U+30DE}\N{U+30BC}\N{U+30F3}\N{U+30BF}","\N{U+9752}\N{U+7DD1}\N{U+8272}","\N{U+871C}\N{U+67D1}\N{U+8272}","\N{U+9F20}\N{U+8272}","\N{U+9ED2}\N{U+3044}","\N{U+9EC4}\N{U+8272}","\N{U+9752}\N{U+3044}","\N{U+8D64}\N{U+3044}","\N{U+8910}\N{U+8272}","\N{U+8336}\N{U+8272}","\N{U+767D}\N{U+3044}","\N{U+72D0}\N{U+8272}","\N{U+7070}\N{U+8272}","\N{U+6A59}\N{U+8272}","\N{U+7DD1}"],
    },
    ko => {
        "\N{U+AC80}\N{U+B2E4}" => 'black',
        "\N{U+AE4C}\N{U+B9E3}\N{U+B2E4}" => 'black',
        "\N{U+D30C}\N{U+B780}\N{U+C0C9}" => 'blue',
        "\N{U+D478}\N{U+B974}\N{U+B2E4}" => 'blue',
        "\N{U+AC08}\N{U+C0C9}" => 'brown',
        "\N{U+CCAD}\N{U+B85D}\N{U+C0C9}" => 'cyan',
        "\N{U+B179}\N{U+C0C9}" => 'green',
        "\N{U+CD08}\N{U+B85D}\N{U+C758}" => 'green',
        "\N{U+D68C}\N{U+C0C9}" => 'grey',
        "\N{U+C7BF}\N{U+BE5B}\N{U+C758}" => 'grey',
        "\N{U+B9C8}\N{U+C820}\N{U+D0C0}\N{U+C0C9}" => 'magenta',
        "\N{U+C624}\N{U+B80C}\N{U+C9C0}\N{U+C0C9}" => 'orange',
        "\N{U+C8FC}\N{U+D669}\N{U+C0C9}" => 'orange',
        "\N{U+BD89}\N{U+B2E4}" => 'red',
        "\N{U+BE68}\N{U+AC1B}\N{U+B2E4}" => 'red',
        "\N{U+D76C}\N{U+B2E4}" => 'white',
        "\N{U+D558}\N{U+C597}\N{U+B2E4}" => 'white',
        "\N{U+B178}\N{U+B780}" => 'yellow',
        __order__ => ["\N{U+C624}\N{U+B80C}\N{U+C9C0}\N{U+C0C9}","\N{U+B9C8}\N{U+C820}\N{U+D0C0}\N{U+C0C9}","\N{U+D558}\N{U+C597}\N{U+B2E4}","\N{U+D478}\N{U+B974}\N{U+B2E4}","\N{U+D30C}\N{U+B780}\N{U+C0C9}","\N{U+CD08}\N{U+B85D}\N{U+C758}","\N{U+CCAD}\N{U+B85D}\N{U+C0C9}","\N{U+C8FC}\N{U+D669}\N{U+C0C9}","\N{U+C7BF}\N{U+BE5B}\N{U+C758}","\N{U+BE68}\N{U+AC1B}\N{U+B2E4}","\N{U+AE4C}\N{U+B9E3}\N{U+B2E4}","\N{U+D76C}\N{U+B2E4}","\N{U+D68C}\N{U+C0C9}","\N{U+BD89}\N{U+B2E4}","\N{U+B179}\N{U+C0C9}","\N{U+B178}\N{U+B780}","\N{U+AC80}\N{U+B2E4}","\N{U+AC08}\N{U+C0C9}"],
    },
    la => {
        'niger' => 'black',
        'ater' => 'black',
        'blavus' => 'blue',
        'azurinus' => 'blue',
        'caeruleus' => 'blue',
        'venetus' => 'blue',
        'cyaneus' => 'blue',
        'glaucus' => 'blue',
        'lividus' => 'blue',
        'brunus' => 'brown',
        'fuscus' => 'brown',
        'aquilus' => 'brown',
        'viridis' => 'green',
        'cinereus' => 'grey',
        'ravus' => 'grey',
        'pullus' => 'grey',
        'canus' => 'grey',
        'aurantius' => 'orange',
        'rubeus' => 'red',
        'rufus' => 'red',
        'vermiculus' => 'red',
        'russus' => 'red',
        'albus' => 'white',
        'candidus' => 'white',
        'flavus' => 'yellow',
        'gilvus' => 'yellow',
        __order__ => ['vermiculus','caeruleus','aurantius','cinereus','candidus','azurinus','viridis','venetus','lividus','glaucus','cyaneus','aquilus','russus','rubeus','pullus','gilvus','fuscus','flavus','brunus','blavus','rufus','ravus','niger','canus','albus','ater'],
    },
    lu => {
        'schwaarz' => 'black',
        'blo' => 'blue',
        'brong' => 'brown',
        "gr\N{U+00E9}ng" => 'green',
        'gro' => 'grey',
        'orange' => 'orange',
        'rout' => 'red',
        "w\N{U+00E4}is" => 'white',
        'giel' => 'yellow',
        __order__ => ['schwaarz','orange',"gr\N{U+00E9}ng",'brong',"w\N{U+00E4}is",'rout','giel','gro','blo'],
    },
    no => {
        'svart' => 'black',
        'sort' => 'black',
        "bl\N{U+00E5}" => 'blue',
        'brun' => 'brown',
        "gr\N{U+00F8}nn" => 'green',
        "gr\N{U+00F8}n" => 'green',
        "gr\N{U+00E5}" => 'grey',
        'oransje' => 'orange',
        'branngul' => 'orange',
        'appelsinfarget' => 'orange',
        "r\N{U+00F8}d" => 'red',
        'raud' => 'red',
        'hvit' => 'white',
        'kvit' => 'white',
        'gul' => 'yellow',
        __order__ => ['appelsinfarget','branngul','oransje','svart',"gr\N{U+00F8}nn",'sort','raud','kvit','hvit',"gr\N{U+00F8}n",'brun',"r\N{U+00F8}d",'gul',"gr\N{U+00E5}","bl\N{U+00E5}"],
    },
    oc => {
        'negre' => 'black',
        'blu' => 'blue',
        'blau' => 'blue',
        'brun' => 'brown',
        'verd' => 'green',
        'gris' => 'grey',
        'irange' => 'orange',
        'roge' => 'red',
        'ros' => 'red',
        'vermelh' => 'red',
        'blanc' => 'white',
        'jaune' => 'yellow',
        __order__ => ['vermelh','irange','negre','jaune','blanc','verd','roge','gris','brun','blau','ros','blu'],
    },
    pt => {
        'preto' => 'black',
        'atro' => 'black',
        'negro' => 'black',
        'azul' => 'blue',
        'marrom' => 'brown',
        'castanho' => 'brown',
        'pardo' => 'brown',
        'ciano' => 'cyan',
        'verde' => 'green',
        'cinzento' => 'grey',
        'gris' => 'grey',
        'magenta' => 'magenta',
        'laranja' => 'orange',
        'vermelho' => 'red',
        'branco' => 'white',
        'amarelo' => 'yellow',
        __order__ => ['vermelho','cinzento','castanho','magenta','laranja','amarelo','marrom','branco','verde','preto','pardo','negro','ciano','gris','azul','atro'],
    },
    ro => {
        'negru' => 'black',
        'sina' => 'blue',
        'albastru' => 'blue',
        'azuriu' => 'blue',
        'brun' => 'brown',
        'maro' => 'brown',
        'cyan' => 'cyan',
        'verde' => 'green',
        'gri' => 'grey',
        'sur' => 'grey',
        "brum\N{U+0103}riu" => 'grey',
        "cenu\N{U+0219}iu" => 'grey',
        'mov' => 'magenta',
        'portocaliu' => 'orange',
        'oranj' => 'orange',
        "ro\N{U+0219}u" => 'red',
        'alb' => 'white',
        'galben' => 'yellow',
        __order__ => ['portocaliu',"brum\N{U+0103}riu",'albastru',"cenu\N{U+0219}iu",'galben','azuriu','verde','oranj','negru','sina',"ro\N{U+0219}u",'maro','cyan','brun','sur','mov','gri','alb'],
    },
    ru => {
        "\N{U+0447}\N{U+0451}\N{U+0440}\N{U+043D}\N{U+044B}\N{U+0439}" => 'black',
        "\N{U+0432}\N{U+043E}\N{U+0440}\N{U+043E}\N{U+043D}\N{U+043E}\N{U+0301}\N{U+0439}" => 'black',
        "\N{U+0441}\N{U+0438}\N{U+043D}\N{U+0438}\N{U+0439}" => 'blue',
        "\N{U+0433}\N{U+043E}\N{U+043B}\N{U+0443}\N{U+0431}\N{U+043E}\N{U+0439}" => 'blue',
        "\N{U+043B}\N{U+0430}\N{U+0437}\N{U+0443}\N{U+0301}\N{U+0440}\N{U+043D}\N{U+044B}\N{U+0439}" => 'blue',
        "\N{U+043A}\N{U+043E}\N{U+0440}\N{U+0438}\N{U+0447}\N{U+043D}\N{U+0435}\N{U+0432}\N{U+044B}\N{U+0439}" => 'brown',
        "\N{U+0431}\N{U+0443}\N{U+0301}\N{U+0440}\N{U+044B}\N{U+0439}" => 'brown',
        "\N{U+0431}\N{U+0438}\N{U+0440}\N{U+044E}\N{U+0437}\N{U+043E}\N{U+0301}\N{U+0432}\N{U+044B}\N{U+0439}" => 'cyan',
        "\N{U+0437}\N{U+0435}\N{U+043B}\N{U+0451}\N{U+043D}\N{U+044B}\N{U+0439}" => 'green',
        "\N{U+0441}\N{U+0435}\N{U+0440}\N{U+044B}\N{U+0439}" => 'grey',
        "\N{U+0441}\N{U+0435}\N{U+0434}\N{U+043E}\N{U+0301}\N{U+0439}" => 'grey',
        "\N{U+0441}\N{U+0438}\N{U+0301}\N{U+0432}\N{U+044B}\N{U+0439}" => 'grey',
        "\N{U+043C}\N{U+0430}\N{U+0434}\N{U+0436}\N{U+0435}\N{U+0301}\N{U+043D}\N{U+0442}\N{U+0430}" => 'magenta',
        "\N{U+043E}\N{U+0440}\N{U+0430}\N{U+043D}\N{U+0436}\N{U+0435}\N{U+0432}\N{U+044B}\N{U+0439}" => 'orange',
        "\N{U+043E}\N{U+0440}\N{U+0430}\N{U+043D}\N{U+0436}\N{U+0435}\N{U+0432}" => 'orange',
        "\N{U+043A}\N{U+0440}\N{U+0430}\N{U+0441}\N{U+043D}\N{U+044B}\N{U+0439}" => 'red',
        "\N{U+0447}\N{U+0435}\N{U+0440}\N{U+0432}\N{U+043E}\N{U+0301}\N{U+043D}\N{U+043D}\N{U+044B}\N{U+0439}" => 'red',
        "\N{U+0430}\N{U+0301}\N{U+043B}\N{U+044B}\N{U+0439}" => 'red',
        "\N{U+0431}\N{U+0435}\N{U+043B}\N{U+044B}\N{U+0439}" => 'white',
        "\N{U+0436}\N{U+0451}\N{U+043B}\N{U+0442}\N{U+044B}\N{U+0439}" => 'yellow',
        __order__ => ["\N{U+0447}\N{U+0435}\N{U+0440}\N{U+0432}\N{U+043E}\N{U+0301}\N{U+043D}\N{U+043D}\N{U+044B}\N{U+0439}","\N{U+043A}\N{U+043E}\N{U+0440}\N{U+0438}\N{U+0447}\N{U+043D}\N{U+0435}\N{U+0432}\N{U+044B}\N{U+0439}","\N{U+0431}\N{U+0438}\N{U+0440}\N{U+044E}\N{U+0437}\N{U+043E}\N{U+0301}\N{U+0432}\N{U+044B}\N{U+0439}","\N{U+043E}\N{U+0440}\N{U+0430}\N{U+043D}\N{U+0436}\N{U+0435}\N{U+0432}\N{U+044B}\N{U+0439}","\N{U+043C}\N{U+0430}\N{U+0434}\N{U+0436}\N{U+0435}\N{U+0301}\N{U+043D}\N{U+0442}\N{U+0430}","\N{U+043B}\N{U+0430}\N{U+0437}\N{U+0443}\N{U+0301}\N{U+0440}\N{U+043D}\N{U+044B}\N{U+0439}","\N{U+0432}\N{U+043E}\N{U+0440}\N{U+043E}\N{U+043D}\N{U+043E}\N{U+0301}\N{U+0439}","\N{U+043E}\N{U+0440}\N{U+0430}\N{U+043D}\N{U+0436}\N{U+0435}\N{U+0432}","\N{U+043A}\N{U+0440}\N{U+0430}\N{U+0441}\N{U+043D}\N{U+044B}\N{U+0439}","\N{U+0437}\N{U+0435}\N{U+043B}\N{U+0451}\N{U+043D}\N{U+044B}\N{U+0439}","\N{U+0433}\N{U+043E}\N{U+043B}\N{U+0443}\N{U+0431}\N{U+043E}\N{U+0439}","\N{U+0447}\N{U+0451}\N{U+0440}\N{U+043D}\N{U+044B}\N{U+0439}","\N{U+0441}\N{U+0438}\N{U+0301}\N{U+0432}\N{U+044B}\N{U+0439}","\N{U+0441}\N{U+0435}\N{U+0434}\N{U+043E}\N{U+0301}\N{U+0439}","\N{U+0436}\N{U+0451}\N{U+043B}\N{U+0442}\N{U+044B}\N{U+0439}","\N{U+0431}\N{U+0443}\N{U+0301}\N{U+0440}\N{U+044B}\N{U+0439}","\N{U+0441}\N{U+0438}\N{U+043D}\N{U+0438}\N{U+0439}","\N{U+0441}\N{U+0435}\N{U+0440}\N{U+044B}\N{U+0439}","\N{U+0431}\N{U+0435}\N{U+043B}\N{U+044B}\N{U+0439}","\N{U+0430}\N{U+0301}\N{U+043B}\N{U+044B}\N{U+0439}"],
    },
    sv => {
        'svart' => 'black',
        "bl\N{U+00E5}" => 'blue',
        'brun' => 'brown',
        'cyan' => 'cyan',
        "gr\N{U+00F6}n" => 'green',
        "gr\N{U+00E5}" => 'grey',
        'orange' => 'orange',
        "apelsinf\N{U+00E4}rgad" => 'orange',
        'brandgul' => 'orange',
        "r\N{U+00F6}d" => 'red',
        'vit' => 'white',
        'gul' => 'yellow',
        __order__ => ["apelsinf\N{U+00E4}rgad",'brandgul','orange','svart',"gr\N{U+00F6}n",'cyan','brun','vit',"r\N{U+00F6}d",'gul',"gr\N{U+00E5}","bl\N{U+00E5}"],
    },
    vi => {
        "\N{U+0111}en" => 'black',
        'lam' => 'blue',
        'xanh' => 'blue',
        "n\N{U+00E2}u" => 'brown',
        "l\N{U+01A1}" => 'cyan',
        "l\N{U+1EE5}c" => 'green',
        "xanhl\N{U+00E1} c\N{U+00E2}y" => 'green',
        "x\N{U+00E1}m" => 'grey',
        'ghi' => 'grey',
        "hoar\N{U+00E2}m" => 'grey',
        "m\N{U+00E0}u\N{U+0111}\N{U+1ECF} s\N{U+1EAD}m" => 'magenta',
        'cam' => 'orange',
        "\N{U+0111}\N{U+1ECF}" => 'red',
        "tr\N{U+1EAF}ng" => 'white',
        "b\N{U+1EA1}ch" => 'white',
        "v\N{U+00E0}ng" => 'yellow',
        __order__ => ["xanhl\N{U+00E1} c\N{U+00E2}y","m\N{U+00E0}u\N{U+0111}\N{U+1ECF} s\N{U+1EAD}m","hoar\N{U+00E2}m","tr\N{U+1EAF}ng",'xanh',"v\N{U+00E0}ng","b\N{U+1EA1}ch","\N{U+0111}en","x\N{U+00E1}m","n\N{U+00E2}u","l\N{U+1EE5}c",'lam','ghi','cam',"\N{U+0111}\N{U+1ECF}","l\N{U+01A1}"],
    },
    zh => {
        "\N{U+9ED1}" => 'black',
        "\N{U+70CF}\N{U+8272}" => 'black',
        "\N{U+85CD}" => 'blue',
        "\N{U+8910}\N{U+8272}" => 'brown',
        "\N{U+68D5}\N{U+8272}" => 'brown',
        "\N{U+5496}\N{U+5561}\N{U+8272}" => 'brown',
        "\N{U+9752}\N{U+8272}" => 'cyan',
        "\N{U+7DA0}" => 'green',
        "\N{U+7070}\N{U+8272}" => 'grey',
        "\N{U+54C1}\N{U+7D05}" => 'magenta',
        "\N{U+6A59}\N{U+8272}" => 'orange',
        "\N{U+6A59}\N{U+9EC3}\N{U+8272}" => 'orange',
        "\N{U+6A58}\N{U+9EC3}\N{U+8272}" => 'orange',
        "\N{U+6A58}\N{U+8272}" => 'orange',
        "\N{U+7D05}" => 'red',
        "\N{U+767D}" => 'white',
        "\N{U+9EC3}" => 'yellow',
        __order__ => ["\N{U+6A59}\N{U+9EC3}\N{U+8272}","\N{U+6A58}\N{U+9EC3}\N{U+8272}","\N{U+5496}\N{U+5561}\N{U+8272}","\N{U+9752}\N{U+8272}","\N{U+8910}\N{U+8272}","\N{U+70CF}\N{U+8272}","\N{U+7070}\N{U+8272}","\N{U+6A59}\N{U+8272}","\N{U+6A58}\N{U+8272}","\N{U+68D5}\N{U+8272}","\N{U+54C1}\N{U+7D05}","\N{U+9ED1}","\N{U+9EC3}","\N{U+85CD}","\N{U+7DA0}","\N{U+7D05}","\N{U+767D}"],
    },
);
our @_langs = qw(en de nl ca da eo es eu fi fo fr ga gl gr is it ja ko la lu no oc pt ro ru sv vi zh);
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Displaycolour::Data - Work with display colours (internal data)

=head1 VERSION

version v0.01

=head1 SYNOPSIS

    use Data::Displaycolour::Data;

This is a internal package that does not expose any public interfaces.

See L<Data::Displaycolour>.

=head1 AUTHOR

Löwenfelsen UG (haftungsbeschränkt) <support@loewenfelsen.net>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2025 by Löwenfelsen UG (haftungsbeschränkt) <support@loewenfelsen.net>.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
