package DBIx::QuickORM::BuildStack;
use strict;
use warnings;

use Carp qw/croak/;
use List::Util qw/first/;

our @STACK;
our %LOOKUP;

sub top { @STACK ? $STACK[-1] : undef }

sub seek_all(&) {
    my $check = shift;
    return grep { $check->($_) } reverse @STACK;
}

sub seek(&) {
    my $check = shift;
    return first { $check->($_) } reverse @STACK;
}

sub building {
    my $type = shift;
    return $LOOKUP{$type};
}

sub define {
    my ($builder, $cb, @args) = @_;

    croak "'$builder' is not an instance of 'DBIx::QuickORM::Builder'"
        unless $builder->isa('DBIx::QuickORM::Builder');

    $cb //= 'UNDEF';
    croak "The second argument must be a coderef, got $cb"
        unless ref($cb) eq 'CODE';

    push @STACK => $builder;
    local $LOOKUP{$builder->build_type} = $builder;

    my $out;
    local $@;
    my $ok = eval { $out = $cb->(@args); 1 };
    my $err = $@;

    pop @STACK;

    die $err unless $ok;

    return $out;
}

sub hide {
    local @STACK;
    local %LOOKUP;

    define(@_);
}

1;
