#!perl
use warnings;
use strict;
use v5.16;
use ntheory ":all";
use feature 'say';

while (<DATA>) {
  chomp;
  next if /^#/ || /^\s*$/;  # skip comments and blank lines
  my($k,$n,$c)=split(" ");
  my $clo = almost_prime_count_lower($k,$n);
  my $chi = almost_prime_count_upper($k,$n);
  die "bad lower count for $k $n: $clo not le $c\n" if $clo > $c;
  die "bad upper count for $k $n: $chi not ge $c\n" if $chi < $c;

  next if $c == 0;
  my $nlo = nth_almost_prime_lower($k,$c);
  my $nhi = nth_almost_prime_upper($k,$c);
  die "bad lower nth for $k $c: $nlo not le $n\n" if $nlo > $n;
  if ($nhi < $n) {
    my $actual = nth_almost_prime($k,$c);
    die "bad upper nth for $k $c: $nhi not ge $n and $actual\n" if $nhi < $actual;
  }
}

print "PASS\n";



__DATA__
#
# k n count for k 50 down to 32, n powers of 2^65 to 2^75
#
50 36893488147419103232 185387
50 73786976294838206464 389954
50 147573952589676412928 817053
50 295147905179352825856 1709640
50 590295810358705651712 3567978
50 1180591620717411303424 7433670
50 2361183241434822606848 15460810
50 4722366482869645213696 32103728
50 9444732965739290427392 66567488
50 18889465931478580854784 137840687
50 37778931862957161709568 285076323
49 36893488147419103232 389954
49 73786976294838206464 817053
49 147573952589676412928 1709640
49 295147905179352825856 3567978
49 590295810358705651712 7433670
49 1180591620717411303424 15460810
49 2361183241434822606848 32103728
49 4722366482869645213696 66567488
49 9444732965739290427392 137840687
49 18889465931478580854784 285076323
49 37778931862957161709568 588891185
48 36893488147419103232 817053
48 73786976294838206464 1709640
48 147573952589676412928 3567978
48 295147905179352825856 7433670
48 590295810358705651712 15460810
48 1180591620717411303424 32103728
48 2361183241434822606848 66567488
48 4722366482869645213696 137840687
48 9444732965739290427392 285076323
48 18889465931478580854784 588891185
48 37778931862957161709568 1215204568
47 36893488147419103232 1709640
47 73786976294838206464 3567978
47 147573952589676412928 7433670
47 295147905179352825856 15460810
47 590295810358705651712 32103728
47 1180591620717411303424 66567488
47 2361183241434822606848 137840687
47 4722366482869645213696 285076323
47 9444732965739290427392 588891185
47 18889465931478580854784 1215204568
47 37778931862957161709568 2505088087
46 36893488147419103232 3567978
46 73786976294838206464 7433670
46 147573952589676412928 15460810
46 295147905179352825856 32103728
46 590295810358705651712 66567488
46 1180591620717411303424 137840687
46 2361183241434822606848 285076323
46 4722366482869645213696 588891185
46 9444732965739290427392 1215204568
46 18889465931478580854784 2505088086
46 37778931862957161709568 5159284080
45 36893488147419103232 7433670
45 73786976294838206464 15460810
45 147573952589676412928 32103728
45 295147905179352825856 66567488
45 590295810358705651712 137840687
45 1180591620717411303424 285076323
45 2361183241434822606848 588891185
45 4722366482869645213696 1215204567
45 9444732965739290427392 2505088084
45 18889465931478580854784 5159284074
45 37778931862957161709568 10616337999
44 36893488147419103232 15460810
44 73786976294838206464 32103728
44 147573952589676412928 66567488
44 295147905179352825856 137840687
44 590295810358705651712 285076323
44 1180591620717411303424 588891185
44 2361183241434822606848 1215204566
44 4722366482869645213696 2505088080
44 9444732965739290427392 5159284062
44 18889465931478580854784 10616337970
44 37778931862957161709568 21827166225
43 36893488147419103232 32103728
43 73786976294838206464 66567488
43 147573952589676412928 137840687
43 295147905179352825856 285076323
43 590295810358705651712 588891184
43 1180591620717411303424 1215204563
43 2361183241434822606848 2505088072
43 4722366482869645213696 5159284043
43 9444732965739290427392 10616337921
43 18889465931478580854784 21827166101
43 37778931862957161709568 44841770229
42 36893488147419103232 66567488
42 73786976294838206464 137840687
42 147573952589676412928 285076323
42 295147905179352825856 588891182
42 590295810358705651712 1215204559
42 1180591620717411303424 2505088059
42 2361183241434822606848 5159284008
42 4722366482869645213696 10616337837
42 9444732965739290427392 21827165897
42 18889465931478580854784 44841769755
42 37778931862957161709568 92054904764
41 36893488147419103232 137840687
41 73786976294838206464 285076322
41 147573952589676412928 588891179
41 295147905179352825856 1215204551
41 590295810358705651712 2505088035
41 1180591620717411303424 5159283950
41 2361183241434822606848 10616337698
41 4722366482869645213696 21827165564
41 9444732965739290427392 44841768976
41 18889465931478580854784 92054902967
41 37778931862957161709568 188846598627
40 36893488147419103232 285076320
40 73786976294838206464 588891173
40 147573952589676412928 1215204535
40 295147905179352825856 2505087994
40 590295810358705651712 5159283853
40 1180591620717411303424 10616337462
40 2361183241434822606848 21827165014
40 4722366482869645213696 44841767695
40 9444732965739290427392 92054900055
40 18889465931478580854784 188846592042
40 37778931862957161709568 387154790784
39 36893488147419103232 588891163
39 73786976294838206464 1215204509
39 147573952589676412928 2505087925
39 295147905179352825856 5159283691
39 590295810358705651712 10616337074
39 1180591620717411303424 21827164114
39 2361183241434822606848 44841765619
39 4722366482869645213696 92054895366
39 9444732965739290427392 188846581484
39 18889465931478580854784 387154767211
39 37778931862957161709568 793210574490
38 36893488147419103232 1215204461
38 73786976294838206464 2505087810
38 147573952589676412928 5159283424
38 295147905179352825856 10616336439
38 590295810358705651712 21827162647
38 1180591620717411303424 44841762273
38 2361183241434822606848 92054887825
38 4722366482869645213696 188846564566
38 9444732965739290427392 387154729605
38 18889465931478580854784 793210491471
38 37778931862957161709568 1624180962108
37 36893488147419103232 2505087624
37 73786976294838206464 5159282975
37 147573952589676412928 10616335393
37 295147905179352825856 21827160268
37 590295810358705651712 44841756876
37 1180591620717411303424 92054875728
37 2361183241434822606848 188846537545
37 4722366482869645213696 387154669824
37 9444732965739290427392 793210359893
37 18889465931478580854784 1624180673981
37 37778931862957161709568 3323800242183
36 36893488147419103232 5159282240
36 73786976294838206464 10616333704
36 147573952589676412928 21827156428
36 295147905179352825856 44841748205
36 590295810358705651712 92054856360
36 1180591620717411303424 188846494478
36 2361183241434822606848 387154574923
36 4722366482869645213696 793210151628
36 9444732965739290427392 1624180219296
36 18889465931478580854784 3323799253575
36 37778931862957161709568 6798324253396
35 36893488147419103232 10616330965
35 73786976294838206464 21827150242
35 147573952589676412928 44841734321
35 295147905179352825856 92054825431
35 590295810358705651712 188846426068
35 1180591620717411303424 387154424592
35 2361183241434822606848 793209822609
35 4722366482869645213696 1624179502721
35 9444732965739290427392 3323797699000
35 18889465931478580854784 6798320894293
35 37778931862957161709568 13897797889642
34 36893488147419103232 21827140299
34 73786976294838206464 44841712120
34 147573952589676412928 92054776170
34 295147905179352825856 188846317569
34 590295810358705651712 387154186733
34 1180591620717411303424 793209303473
34 2361183241434822606848 1624178375068
34 4722366482869645213696 3323795258362
34 9444732965739290427392 6798315630913
34 18889465931478580854784 13897786571872
34 37778931862957161709568 28397331476238
33 36893488147419103232 44841676716
33 73786976294838206464 92054697931
33 147573952589676412928 188846145779
33 295147905179352825856 387153811074
33 590295810358705651712 793208485858
33 1180591620717411303424 1624176602998
33 2361183241434822606848 3323791430535
33 4722366482869645213696 6798307390826
33 9444732965739290427392 13897768885128
33 18889465931478580854784 28397293622195
33 37778931862957161709568 57997025059232
32 36893488147419103232 92054573895
32 73786976294838206464 188845874114
32 147573952589676412928 387153218646
32 295147905179352825856 793207199668
32 590295810358705651712 1624173821202
32 1180591620717411303424 3323785433921
32 2361183241434822606848 6798294505172
32 4722366482869645213696 13897741273215
32 9444732965739290427392 28397234611879
32 18889465931478580854784 57996899244903
32 37778931862957161709568 118396626650197
#
# k n count for various large k and n.
#
# n 2^61
50 2305843009213693952 9184
49 2305843009213693952 19611
48 2305843009213693952 41604
47 2305843009213693952 87993
46 2305843009213693952 185387
45 2305843009213693952 389954
44 2305843009213693952 817053
43 2305843009213693952 1709640
42 2305843009213693952 3567978
41 2305843009213693952 7433670
40 2305843009213693952 15460810
39 2305843009213693952 32103728
38 2305843009213693952 66567487
37 2305843009213693952 137840679
36 2305843009213693952 285076274
35 2305843009213693952 588890969
34 2305843009213693952 1215203665
33 2305843009213693952 2505084574
32 2305843009213693952 5159270863
31 2305843009213693952 10616289827
30 2305843009213693952 21826993919
29 2305843009213693952 44841164956
28 2305843009213693952 92052806400
27 2305843009213693952 188839407735
26 2305843009213693952 387130383261
25 2305843009213693952 793128408178
24 2305843009213693952 1623906336546
23 2305843009213693952 3322888083693
22 2305843009213693952 6795311371282
21 2305843009213693952 13887895368206
20 2305843009213693952 28364929292854
19 2305843009213693952 57891427457709
18 2305843009213693952 118053750614948
17 2305843009213693952 240484564287559
16 2305843009213693952 489202084580191
15 2305843009213693952 993219838185333
14 2305843009213693952 2010852272976848
13 2305843009213693952 4054082956829350
12 2305843009213693952 8121421789026587
#
# n 2^62
50 4611686018427387904 19611
49 4611686018427387904 41604
48 4611686018427387904 87993
47 4611686018427387904 185387
46 4611686018427387904 389954
45 4611686018427387904 817053
44 4611686018427387904 1709640
43 4611686018427387904 3567978
42 4611686018427387904 7433670
41 4611686018427387904 15460810
40 4611686018427387904 32103728
39 4611686018427387904 66567488
38 4611686018427387904 137840683
37 4611686018427387904 285076296
36 4611686018427387904 588891060
35 4611686018427387904 1215204027
34 4611686018427387904 2505085950
33 4611686018427387904 5159275951
32 4611686018427387904 10616308060
31 4611686018427387904 21827058367
30 4611686018427387904 44841389241
29 4611686018427387904 92053577623
28 4611686018427387904 188842033229
27 4611686018427387904 387139242594
26 4611686018427387904 793158083381
25 4611686018427387904 1624005082298
24 4611686018427387904 3323214786505
23 4611686018427387904 6796386710871
22 4611686018427387904 13891418655723
21 4611686018427387904 28376425147307
20 4611686018427387904 57928794866619
19 4611686018427387904 118174791722978
18 4611686018427387904 240875370160260
17 4611686018427387904 490459957003389
16 4611686018427387904 997255906585879
#
# n 2^63
50 9223372036854775808 41604
49 9223372036854775808 87993
48 9223372036854775808 185387
47 9223372036854775808 389954
46 9223372036854775808 817053
45 9223372036854775808 1709640
44 9223372036854775808 3567978
43 9223372036854775808 7433670
42 9223372036854775808 15460810
41 9223372036854775808 32103728
40 9223372036854775808 66567488
39 9223372036854775808 137840685
38 9223372036854775808 285076309
37 9223372036854775808 588891113
36 9223372036854775808 1215204250
35 9223372036854775808 2505086797
34 9223372036854775808 5159279091
33 9223372036854775808 10616319464
32 9223372036854775808 21827098899
31 9223372036854775808 44841530987
30 9223372036854775808 92054067228
29 9223372036854775808 188843705453
28 9223372036854775808 387144903124
27 9223372036854775808 793177093966
26 9223372036854775808 1624068487060
25 9223372036854775808 3323424993038
24 9223372036854775808 6797079873722
23 9223372036854775808 13893693496440
22 9223372036854775808 28383858637957
21 9223372036854775808 57952990683107
20 9223372036854775808 118253267723513
19 9223372036854775808 241129059619567
18 9223372036854775808 491277525438318
17 9223372036854775808 999882846764610
16 9223372036854775808 2032174655403956
#
# n 2^64-1
64 18446744073709551615 0
63 18446744073709551615 2
62 18446744073709551615 7
61 18446744073709551615 15
60 18446744073709551615 37
59 18446744073709551615 84
58 18446744073709551615 187
57 18446744073709551615 421
56 18446744073709551615 914
55 18446744073709551615 2001
54 18446744073709551615 4283
53 18446744073709551615 9184
52 18446744073709551615 19611
51 18446744073709551615 41604
50 18446744073709551615 87993
49 18446744073709551615 185387
48 18446744073709551615 389954
47 18446744073709551615 817053
46 18446744073709551615 1709640
45 18446744073709551615 3567978
44 18446744073709551615 7433670
43 18446744073709551615 15460810
42 18446744073709551615 32103728
41 18446744073709551615 66567488
40 18446744073709551615 137840686
39 18446744073709551615 285076316
38 18446744073709551615 588891145
37 18446744073709551615 1215204383
36 18446744073709551615 2505087309
35 18446744073709551615 5159281045
34 18446744073709551615 10616326552
33 18446744073709551615 21827124353
32 18446744073709551615 44841620426
31 18446744073709551615 92054377509
30 18446744073709551615 188844769357
29 18446744073709551615 387148515886
28 18446744073709551615 793189260998
27 18446744073709551615 1624109166018
26 18446744073709551615 3323560145881
25 18446744073709551615 6797526392535
24 18446744073709551615 13895161400556
23 18446744073709551615 28388662714236
22 18446744073709551615 57968649799947
21 18446744073709551615 118304122014405
20 18446744073709551615 241293656953012
19 18446744073709551615 491808604962296
18 18446744073709551615 1001591348315641
17 18446744073709551615 2037655246635364
16 18446744073709551615 4139595949113890
15 18446744073709551615 8393048221327186
14 18446744073709551615 16967424859951587
13 18446744073709551615 34151861008771016
12 18446744073709551615 68283616225825256
11 18446744073709551615 135128109904869290
10 18446744073709551615 263157990621533964
9 18446744073709551615 499840874923678341
8 18446744073709551615 913164427599983727
7 18446744073709551615 1571012171387856192
6 18446744073709551615 2466706950238087748
5 18446744073709551615 3378907169603895030
4 18446744073709551615 3787884015050788482
3 18446744073709551615 3167597434038354478
2 18446744073709551615 1701748900850019777
1 18446744073709551615 425656284035217743
#
# n 2^65
42 36893488147419103232 66567488
41 36893488147419103232 137840687
40 36893488147419103232 285076320
39 36893488147419103232 588891163
38 36893488147419103232 1215204461
37 36893488147419103232 2505087624
36 36893488147419103232 5159282240
35 36893488147419103232 10616330965
34 36893488147419103232 21827140299
#
# n 2^66
42 73786976294838206464 137840687
41 73786976294838206464 285076322
40 73786976294838206464 588891173
39 73786976294838206464 1215204509
#
# n 2^67
42 147573952589676412928 285076323
41 147573952589676412928 588891179
40 147573952589676412928 1215204535
39 147573952589676412928 2505087925
38 147573952589676412928 5159283424
37 147573952589676412928 10616335393
36 147573952589676412928 21827156428
35 147573952589676412928 44841734321
34 147573952589676412928 92054776170
33 147573952589676412928 188846145779
32 147573952589676412928 387153218646
31 147573952589676412928 793205179283
30 147573952589676412928 1624162629558
29 147573952589676412928 3323738467309
28 147573952589676412928 6798117607159
27 147573952589676412928 13897111023968
26 147573952589676412928 28395061243805
#
# n 2^70
50 1180591620717411303424 7433670
49 1180591620717411303424 15460810
48 1180591620717411303424 32103728
47 1180591620717411303424 66567488
46 1180591620717411303424 137840687
45 1180591620717411303424 285076323
44 1180591620717411303424 588891185
43 1180591620717411303424 1215204563
42 1180591620717411303424 2505088059
41 1180591620717411303424 5159283950
40 1180591620717411303424 10616337462
39 1180591620717411303424 21827164114
38 1180591620717411303424 44841762273
37 1180591620717411303424 92054875728
36 1180591620717411303424 188846494478
35 1180591620717411303424 387154424592
34 1180591620717411303424 793209303473
33 1180591620717411303424 1624176602998
32 1180591620717411303424 3323785433921
31 1180591620717411303424 6798274373931
30 1180591620717411303424 13897631080548
29 1180591620717411303424 28396777171142
28 1180591620717411303424 57995193392113
27 1180591620717411303424 118390604234288
26 1180591620717411303424 241574405535782
25 1180591620717411303424 492716978857699
24 1180591620717411303424 1004521422339203
23 1180591620717411303424 2047079488688087
22 1180591620717411303424 4169825122934310
#
# n 2^80
70 1208925819614629174706176 4283
69 1208925819614629174706176 9184
68 1208925819614629174706176 19611
67 1208925819614629174706176 41604
66 1208925819614629174706176 87993
65 1208925819614629174706176 185387
64 1208925819614629174706176 389954
63 1208925819614629174706176 817053
62 1208925819614629174706176 1709640
61 1208925819614629174706176 3567978
60 1208925819614629174706176 7433670
59 1208925819614629174706176 15460810
58 1208925819614629174706176 32103728
57 1208925819614629174706176 66567488
56 1208925819614629174706176 137840687
55 1208925819614629174706176 285076323
54 1208925819614629174706176 588891185
53 1208925819614629174706176 1215204568
52 1208925819614629174706176 2505088087
51 1208925819614629174706176 5159284087
50 1208925819614629174706176 10616338035
49 1208925819614629174706176 21827166388
48 1208925819614629174706176 44841770893
47 1208925819614629174706176 92054907365
46 1208925819614629174706176 188846608343
45 1208925819614629174706176 387154826263
44 1208925819614629174706176 793210701031
43 1208925819614629174706176 1624181406484
42 1208925819614629174706176 3323801781048
41 1208925819614629174706176 6798329523559
40 1208925819614629174706176 13897815765484
39 1208925819614629174706176 28397391623028
38 1208925819614629174706176 57997225987154
37 1208925819614629174706176 118397293732399
36 1208925819614629174706176 241596320912299
35 1208925819614629174706176 492788479670113
