package Bundle::Colloquy::BotBot2;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Colloquy::BotBot2 - A bundle to install all modules required for BotBot2

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Bundle::Colloquy::BotBot2'>

=head1 CONTENTS

Colloquy::Bot::Simple - Simple robot interface for Colloquy

Colloquy::Data - Read Colloquy 1.3 and 1.4 data files

Config::General - Generic Config Module

Data::Dumper - stringified perl data structures, suitable for both

DBI - Database independent interface for Perl

File::Type - determine file type using magic

Finance::Currency::Convert::XE - Currency conversion module.

FindBin - Locate directory of original perl script

HTML::Entities - Encode or decode strings with HTML entities

HTML::Strip - Perl extension for stripping HTML markup from text.

Image::Info - Extract meta information from image files

LWP::Simple - simple procedural interface to LWP

LWP::UserAgent - Web user agent class

Net::Dict - client API for accessing dictionary servers (RFC 2229)

Net::Finger - a Perl implementation of a finger client.

Net::Whois::IANA - A universal WHOIS data extractor.

RRD::Simple - Simple interface to create and store data in RRD files

SOAP::Lite - Client and server side SOAP implementation

Text::Aspell - Perl interface to the GNU Aspell library

URI::Escape - Escape and unescape unsafe characters

Weather::Cached - Perl extension for getting weather information from

WebService::Google::Sets - Perl access to Google Labs Sets site

WWW::Google::Calculator - Perl interface for Google calculator

WWW::Search - Virtual base class for WWW searches

XML::Simple - Easy API to maintain XML (esp config files)

=head1 DESCRIPTION

This bundle installs a bunch of modules related required to make
BotBot version 2 for Colloquy (and Nilex) talkers, install and
function correctly.

=head1 SEE ALSO

L<https://svn.perlgirl.org.uk/dav/botbot2/>

=head1 VERSION

$Id: Simple.pm 429 2006-05-01 21:10:56Z nicolaw $

=head1 AUTHOR

Nicola Worthington <nicolaw@cpan.org>

L<http://perlgirl.org.uk>

=head1 COPYRIGHT

Copyright 2006 Nicola Worthington.

This software is licensed under The Apache Software License, Version 2.0.

L<http://www.apache.org/licenses/LICENSE-2.0>

=cut
