# Generated by default/object.tt
package Paws::CostExplorer::SortDefinition;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has SortOrder => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::SortDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::SortDefinition object:

  $service_obj->Method(Att1 => { Key => $value, ..., SortOrder => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::SortDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

The details of how to sort the data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The key by which to sort the data.


=head2 SortOrder => Str

The order in which to sort the data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

