# Generated by default/object.tt
package Paws::DataExchange::ExportServerSideEncryption;
  use Moose;
  has KmsKeyArn => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DataExchange::ExportServerSideEncryption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DataExchange::ExportServerSideEncryption object:

  $service_obj->Method(Att1 => { KmsKeyArn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DataExchange::ExportServerSideEncryption object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyArn

=head1 DESCRIPTION

Encryption configuration of the export job. Includes the encryption
type as well as the AWS KMS key. The KMS key is only necessary if you
chose the KMS encryption type.

=head1 ATTRIBUTES


=head2 KmsKeyArn => Str

The Amazon Resource Name (ARN) of the the AWS KMS key you want to use
to encrypt the Amazon S3 objects. This parameter is required if you
choose aws:kms as an encryption type.


=head2 B<REQUIRED> Type => Str

The type of server side encryption used for encrypting the objects in
Amazon S3.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DataExchange>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

