# Generated by default/object.tt
package Paws::GreengrassV2::Deployment;
  use Moose;
  has CreationTimestamp => (is => 'ro', isa => 'Str', request_name => 'creationTimestamp', traits => ['NameInRequest']);
  has DeploymentId => (is => 'ro', isa => 'Str', request_name => 'deploymentId', traits => ['NameInRequest']);
  has DeploymentName => (is => 'ro', isa => 'Str', request_name => 'deploymentName', traits => ['NameInRequest']);
  has DeploymentStatus => (is => 'ro', isa => 'Str', request_name => 'deploymentStatus', traits => ['NameInRequest']);
  has IsLatestForTarget => (is => 'ro', isa => 'Bool', request_name => 'isLatestForTarget', traits => ['NameInRequest']);
  has RevisionId => (is => 'ro', isa => 'Str', request_name => 'revisionId', traits => ['NameInRequest']);
  has TargetArn => (is => 'ro', isa => 'Str', request_name => 'targetArn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::Deployment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::Deployment object:

  $service_obj->Method(Att1 => { CreationTimestamp => $value, ..., TargetArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::Deployment object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTimestamp

=head1 DESCRIPTION

Contains information about a deployment.

=head1 ATTRIBUTES


=head2 CreationTimestamp => Str

The time at which the deployment was created, expressed in ISO 8601
format.


=head2 DeploymentId => Str

The ID of the deployment.


=head2 DeploymentName => Str

The name of the deployment.

You can create deployments without names. If you create a deployment
without a name, the AWS IoT Greengrass V2 console shows the deployment
name as C<E<lt>targetTypeE<gt>:E<lt>targetNameE<gt>>, where
C<targetType> and C<targetName> are the type and name of the deployment
target.


=head2 DeploymentStatus => Str

The status of the deployment.


=head2 IsLatestForTarget => Bool

Whether or not the deployment is the latest revision for its target.


=head2 RevisionId => Str

The revision number of the deployment.


=head2 TargetArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the target AWS IoT thing or thing group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

