# Generated by default/object.tt
package Paws::MediaConvert::CmfcSettings;
  use Moose;
  has AudioDuration => (is => 'ro', isa => 'Str', request_name => 'audioDuration', traits => ['NameInRequest']);
  has AudioGroupId => (is => 'ro', isa => 'Str', request_name => 'audioGroupId', traits => ['NameInRequest']);
  has AudioRenditionSets => (is => 'ro', isa => 'Str', request_name => 'audioRenditionSets', traits => ['NameInRequest']);
  has AudioTrackType => (is => 'ro', isa => 'Str', request_name => 'audioTrackType', traits => ['NameInRequest']);
  has DescriptiveVideoServiceFlag => (is => 'ro', isa => 'Str', request_name => 'descriptiveVideoServiceFlag', traits => ['NameInRequest']);
  has IFrameOnlyManifest => (is => 'ro', isa => 'Str', request_name => 'iFrameOnlyManifest', traits => ['NameInRequest']);
  has Scte35Esam => (is => 'ro', isa => 'Str', request_name => 'scte35Esam', traits => ['NameInRequest']);
  has Scte35Source => (is => 'ro', isa => 'Str', request_name => 'scte35Source', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::CmfcSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::CmfcSettings object:

  $service_obj->Method(Att1 => { AudioDuration => $value, ..., Scte35Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::CmfcSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AudioDuration

=head1 DESCRIPTION

These settings relate to the fragmented MP4 container for the segments
in your CMAF outputs.

=head1 ATTRIBUTES


=head2 AudioDuration => Str

Specify this setting only when your output will be consumed by a
downstream repackaging workflow that is sensitive to very small
duration differences between video and audio. For this situation,
choose Match video duration (MATCH_VIDEO_DURATION). In all other cases,
keep the default value, Default codec duration
(DEFAULT_CODEC_DURATION). When you choose Match video duration,
MediaConvert pads the output audio streams with silence or trims them
to ensure that the total duration of each audio stream is at least as
long as the total duration of the video stream. After padding or
trimming, the audio stream duration is no more than one frame longer
than the video stream. MediaConvert applies audio padding or trimming
only to the end of the last segment of the output. For unsegmented
outputs, MediaConvert adds padding only to the end of the file. When
you keep the default value, any minor discrepancies between audio and
video duration will depend on your output audio codec.


=head2 AudioGroupId => Str

Specify the audio rendition group for this audio rendition. Specify up
to one value for each audio output in your output group. This value
appears in your HLS parent manifest in the EXT-X-MEDIA tag of
TYPE=AUDIO, as the value for the GROUP-ID attribute. For example, if
you specify "audio_aac_1" for Audio group ID, it appears in your
manifest like this: #EXT-X-MEDIA:TYPE=AUDIO,GROUP-ID="audio_aac_1".
Related setting: To associate the rendition group that this audio track
belongs to with a video rendition, include the same value that you
provide here for that video output's setting Audio rendition sets
(audioRenditionSets).


=head2 AudioRenditionSets => Str

List the audio rendition groups that you want included with this video
rendition. Use a comma-separated list. For example, say you want to
include the audio rendition groups that have the audio group IDs
"audio_aac_1" and "audio_dolby". Then you would specify this value:
"audio_aac_1, audio_dolby". Related setting: The rendition groups that
you include in your comma-separated list should all match values that
you specify in the setting Audio group ID (AudioGroupId) for audio
renditions in the same output group as this video rendition. Default
behavior: If you don't specify anything here and for Audio group ID,
MediaConvert puts each audio variant in its own audio rendition group
and associates it with every video variant. Each value in your list
appears in your HLS parent manifest in the EXT-X-STREAM-INF tag as the
value for the AUDIO attribute. To continue the previous example, say
that the file name for the child manifest for your video rendition is
"amazing_video_1.m3u8". Then, in your parent manifest, each value will
appear on separate lines, like this:


=head2 AudioTrackType => Str

Use this setting to control the values that MediaConvert puts in your
HLS parent playlist to control how the client player selects which
audio track to play. The other options for this setting determine the
values that MediaConvert writes for the DEFAULT and AUTOSELECT
attributes of the EXT-X-MEDIA entry for the audio variant. For more
information about these attributes, see the Apple documentation article
https://developer.apple.com/documentation/http_live_streaming/example_playlists_for_http_live_streaming/adding_alternate_media_to_a_playlist.
Choose Alternate audio, auto select, default
(ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT) to set DEFAULT=YES and
AUTOSELECT=YES. Choose this value for only one variant in your output
group. Choose Alternate audio, auto select, not default
(ALTERNATE_AUDIO_AUTO_SELECT) to set DEFAULT=NO and AUTOSELECT=YES.
Choose Alternate Audio, Not Auto Select to set DEFAULT=NO and
AUTOSELECT=NO. When you don't specify a value for this setting,
MediaConvert defaults to Alternate audio, auto select, default. When
there is more than one variant in your output group, you must
explicitly choose a value for this setting.


=head2 DescriptiveVideoServiceFlag => Str

Specify whether to flag this audio track as descriptive video service
(DVS) in your HLS parent manifest. When you choose Flag (FLAG),
MediaConvert includes the parameter
CHARACTERISTICS="public.accessibility.describes-video" in the
EXT-X-MEDIA entry for this track. When you keep the default choice,
Don't flag (DONT_FLAG), MediaConvert leaves this parameter out. The DVS
flag can help with accessibility on Apple devices. For more
information, see the Apple documentation.


=head2 IFrameOnlyManifest => Str

Choose Include (INCLUDE) to have MediaConvert generate an HLS child
manifest that lists only the I-frames for this rendition, in addition
to your regular manifest for this rendition. You might use this
manifest as part of a workflow that creates preview functions for your
video. MediaConvert adds both the I-frame only child manifest and the
regular child manifest to the parent manifest. When you don't need the
I-frame only child manifest, keep the default value Exclude (EXCLUDE).


=head2 Scte35Esam => Str

Use this setting only when you specify SCTE-35 markers from ESAM.
Choose INSERT to put SCTE-35 markers in this output at the insertion
points that you specify in an ESAM XML document. Provide the document
in the setting SCC XML (sccXml).


=head2 Scte35Source => Str

Ignore this setting unless you have SCTE-35 markers in your input video
file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that
appear in your input to also appear in this output. Choose None (NONE)
if you don't want those SCTE-35 markers in this output.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

