# Generated by default/object.tt
package Paws::ResourceGroups::ListGroupResourcesItem;
  use Moose;
  has Identifier => (is => 'ro', isa => 'Paws::ResourceGroups::ResourceIdentifier');
  has Status => (is => 'ro', isa => 'Paws::ResourceGroups::ResourceStatus');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ResourceGroups::ListGroupResourcesItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ResourceGroups::ListGroupResourcesItem object:

  $service_obj->Method(Att1 => { Identifier => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ResourceGroups::ListGroupResourcesItem object:

  $result = $service_obj->Method(...);
  $result->Att1->Identifier

=head1 DESCRIPTION

A structure returned by the ListGroupResources operation that contains
identity and group membership status information for one of the
resources in the group.

=head1 ATTRIBUTES


=head2 Identifier => L<Paws::ResourceGroups::ResourceIdentifier>




=head2 Status => L<Paws::ResourceGroups::ResourceStatus>

A structure that contains the status of this resource's membership in
the group.

This field is present in the response only if the group is of type
C<AWS::EC2::HostManagement>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ResourceGroups>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

