# Generated by default/object.tt
package Paws::Robomaker::WorldFailure;
  use Moose;
  has FailureCode => (is => 'ro', isa => 'Str', request_name => 'failureCode', traits => ['NameInRequest']);
  has FailureCount => (is => 'ro', isa => 'Int', request_name => 'failureCount', traits => ['NameInRequest']);
  has SampleFailureReason => (is => 'ro', isa => 'Str', request_name => 'sampleFailureReason', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::WorldFailure

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::WorldFailure object:

  $service_obj->Method(Att1 => { FailureCode => $value, ..., SampleFailureReason => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::WorldFailure object:

  $result = $service_obj->Method(...);
  $result->Att1->FailureCode

=head1 DESCRIPTION

Information about a failed world.

=head1 ATTRIBUTES


=head2 FailureCode => Str

The failure code of the world export job if it failed:

=over

=item InternalServiceError

Internal service error.

=item LimitExceeded

The requested resource exceeds the maximum number allowed, or the
number of concurrent stream requests exceeds the maximum number
allowed.

=item ResourceNotFound

The specified resource could not be found.

=item RequestThrottled

The request was throttled.

=item InvalidInput

An input parameter in the request is not valid.

=back



=head2 FailureCount => Int

The number of failed worlds.


=head2 SampleFailureReason => Str

The sample reason why the world failed. World errors are aggregated. A
sample is used as the C<sampleFailureReason>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

