# Generated by default/object.tt
package Paws::SageMaker::OidcConfig;
  use Moose;
  has AuthorizationEndpoint => (is => 'ro', isa => 'Str', required => 1);
  has ClientId => (is => 'ro', isa => 'Str', required => 1);
  has ClientSecret => (is => 'ro', isa => 'Str', required => 1);
  has Issuer => (is => 'ro', isa => 'Str', required => 1);
  has JwksUri => (is => 'ro', isa => 'Str', required => 1);
  has LogoutEndpoint => (is => 'ro', isa => 'Str', required => 1);
  has TokenEndpoint => (is => 'ro', isa => 'Str', required => 1);
  has UserInfoEndpoint => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OidcConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OidcConfig object:

  $service_obj->Method(Att1 => { AuthorizationEndpoint => $value, ..., UserInfoEndpoint => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OidcConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationEndpoint

=head1 DESCRIPTION

Use this parameter to configure your OIDC Identity Provider (IdP).

=head1 ATTRIBUTES


=head2 B<REQUIRED> AuthorizationEndpoint => Str

The OIDC IdP authorization endpoint used to configure your private
workforce.


=head2 B<REQUIRED> ClientId => Str

The OIDC IdP client ID used to configure your private workforce.


=head2 B<REQUIRED> ClientSecret => Str

The OIDC IdP client secret used to configure your private workforce.


=head2 B<REQUIRED> Issuer => Str

The OIDC IdP issuer used to configure your private workforce.


=head2 B<REQUIRED> JwksUri => Str

The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
workforce.


=head2 B<REQUIRED> LogoutEndpoint => Str

The OIDC IdP logout endpoint used to configure your private workforce.


=head2 B<REQUIRED> TokenEndpoint => Str

The OIDC IdP token endpoint used to configure your private workforce.


=head2 B<REQUIRED> UserInfoEndpoint => Str

The OIDC IdP user information endpoint used to configure your private
workforce.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

