# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 2 * 222;

use Math::BigInt::Lite;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigInt::Lite -> accuracy($accu);|
                 . qq| \$x = Math::BigInt::Lite -> new("$x_str");|
                 . qq| \$str = \$x -> bestr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0
-0:0e+0

# positive numbers

1:1e+0
10:10e+0
100:100e+0
1000:1e+3
10000:10e+3
100000:100e+3
1000000:1e+6
10000000:10e+6
100000000:100e+6
1000000000:1e+9
10000000000:10e+9
100000000000:100e+9
1000000000000:1e+12

12:12e+0
120:120e+0
1200:1.2e+3
12000:12e+3
120000:120e+3
1200000:1.2e+6
12000000:12e+6
120000000:120e+6
1200000000:1.2e+9
12000000000:12e+9
120000000000:120e+9
1200000000000:1.2e+12

123:123e+0
1230:1.23e+3
12300:12.3e+3
123000:123e+3
1230000:1.23e+6
12300000:12.3e+6
123000000:123e+6
1230000000:1.23e+9
12300000000:12.3e+9
123000000000:123e+9
1230000000000:1.23e+12

1234:1.234e+3
12340:12.34e+3
123400:123.4e+3
1234000:1.234e+6
12340000:12.34e+6
123400000:123.4e+6
1234000000:1.234e+9
12340000000:12.34e+9
123400000000:123.4e+9
1234000000000:1.234e+12

3:3e+0
31:31e+0
314:314e+0
3141:3.141e+3
31415:31.415e+3
314159:314.159e+3
3141592:3.141592e+6

# negative numbers

-1:-1e+0
-10:-10e+0
-100:-100e+0
-1000:-1e+3
-10000:-10e+3
-100000:-100e+3
-1000000:-1e+6
-10000000:-10e+6
-100000000:-100e+6
-1000000000:-1e+9
-10000000000:-10e+9
-100000000000:-100e+9
-1000000000000:-1e+12

-12:-12e+0
-120:-120e+0
-1200:-1.2e+3
-12000:-12e+3
-120000:-120e+3
-1200000:-1.2e+6
-12000000:-12e+6
-120000000:-120e+6
-1200000000:-1.2e+9
-12000000000:-12e+9
-120000000000:-120e+9
-1200000000000:-1.2e+12

-123:-123e+0
-1230:-1.23e+3
-12300:-12.3e+3
-123000:-123e+3
-1230000:-1.23e+6
-12300000:-12.3e+6
-123000000:-123e+6
-1230000000:-1.23e+9
-12300000000:-12.3e+9
-123000000000:-123e+9
-1230000000000:-1.23e+12

-1234:-1.234e+3
-12340:-12.34e+3
-123400:-123.4e+3
-1234000:-1.234e+6
-12340000:-12.34e+6
-123400000:-123.4e+6
-1234000000:-1.234e+9
-12340000000:-12.34e+9
-123400000000:-123.4e+9
-1234000000000:-1.234e+12

-3:-3e+0
-31:-31e+0
-314:-314e+0
-3141:-3.141e+3
-31415:-31.415e+3
-314159:-314.159e+3
-3141592:-3.141592e+6
